<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/nmfp2"
	xmlns:ns3="http://www.sec.gov/edgar/nmfp2common">
	
	<xsl:template name="item1_generalInformation">
		<h3>General Information</h3>
		<table id="generalInfomration">
			<tr>
				<td class="label"><b>Item 1.</b> Report for [YYYY-MM-DD]:</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:reportDate)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item 2.</b> CIK Number of Registrant.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:cik)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item 3.</b> LEI of Registrant (if available) (See General Instructions E.)</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:registrantLEIId)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><b>Item 4.</b> EDGAR Series Identifier.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:seriesId)" />
					</div>
				</td>
			</tr>
			<tr  >
				<td class="label"><b>Item 5.</b> Total number of share classes in the series.</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:totalShareClassesInSeries)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>Item 6.</b> Do you anticipate that this will be the fund's final filing on Form N-MFP? If Yes, answer Items 6.a - 6.c.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:finalFilingFlag) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:finalFilingFlag) = 'N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>				
			</tr>
			
			<xsl:if test="string(m1:generalInfo/m1:finalFilingFlag) = 'Y'">
				<tr>
					<td class="label">
						<blockquote>
							a. Is the fund liquidating?
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundLiquidatingFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundLiquidatingFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>						
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							b. Is the fund merging with, or being acquired by, another fund?
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundMrgOrAcqrdByOthrFlag) = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
							</xsl:otherwise>
						</xsl:choose> &#160;
						<xsl:choose>
							<xsl:when test="string(m1:generalInfo/m1:fundMrgOrAcqrdByOthrFlag) = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
							</xsl:otherwise>
						</xsl:choose>							
					</td>
				</tr>
				<xsl:if test="count(m1:generalInfo/m1:successorFund) &gt; 0">
					<tr>
						<td class="label">
							<blockquote>
								c. If applicable, identify the successor fund by CIK, 
								Securities Act file number, and EDGAR series identifier.
							</blockquote>
						</td>
					</tr>
					<xsl:if test="string(m1:generalInfo/m1:fundMrgOrAcqrdByOthrFlag) = 'Y'">
						<xsl:for-each select="m1:generalInfo/m1:successorFund">
							<tr>
								<td class="label"><blockquote>CIK of successor fund</blockquote></td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:cik" />
									</div>
								</td>
							</tr>
							<tr>	
								<td class="label">
									<blockquote>Securities Act file number of successor fund</blockquote>
								</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:fileNumber" />
									</div>
								</td>
							</tr>
							<tr>
								<td class="label">
									<blockquote>EDGAR series identifier of successor fund</blockquote>
								</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="m1:seriesId" />
									</div>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label"><b>Item 7.</b> Has the fund acquired or merged with another fund since the last filing?</td>
				<td>								
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:fundAcqrdOrMrgdWthAnthrFlag)='Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
						</xsl:otherwise>
					</xsl:choose> &#160;
					<xsl:choose>
						<xsl:when test="string(m1:generalInfo/m1:fundAcqrdOrMrgdWthAnthrFlag)='N'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			<tr>
				<td class="label">If Yes, answer Item 7.a.</td>
				<td></td>
			</tr>
			<xsl:if test="string(m1:generalInfo/m1:fundAcqrdOrMrgdWthAnthrFlag) = 'Y'">
				<tr>
					<td class="label">
						a. Identify the acquired or merged fund by CIK, Securities Act file number, and EDGAR series identifier.
					</td>
					<td>
					</td>
				</tr>
				<xsl:for-each select="m1:generalInfo/m1:acquiredMergedFund">
					<tr>
						<td class="label">
							<blockquote>CIK of acquired/merged fund</blockquote>
						</td> 
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:cik" />
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Securities Act file number of acquired/merged fund
							</blockquote>
						</td> 
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:fileNumber" />
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								EDGAR series identifier of acquired/merged fund
							</blockquote>
						</td> 
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="m1:seriesId" />
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label">
					<b>Item 8.</b> Provide the name, e-mail address, and telephone number of the person authorized to receive information and respond to questions about this Form N-MFP
				</td>
				<td>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Name</blockquote></td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="string(m1:generalInfo/m1:contact2/m1:contactName)" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Phone Number</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="string(m1:generalInfo/m1:contact2/m1:contactPhoneNumber)" />
					</div>
				</td>				
			</tr>
			<tr>
				<td class="label"><blockquote>Email Address</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="string(m1:generalInfo/m1:contact2/m1:contactEmailAddress)" />
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>

